<?php /**
  * @file
  * Contains \Drupal\tmgmt_xtm_connect\Controller\XTMConnectController.
  */

namespace Drupal\tmgmt_xtm_connect\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\tmgmt\Entity\Job;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Route controller class for the tmgmt_xtm_connect module.
 */
class XTMConnectController extends ControllerBase
{
  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * Constructs a new XTMConnectController object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager) {
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('entity_type.manager')
    );
  }

  /**
   * Provides a callback function for tmgmt_xtm_connect translator.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request to handle.
   *
   * @return \Symfony\Component\HttpFoundation\JsonResponse
   *   The response to return.
   */
  public function applyTranslations(Request $request, $jobId)
  {
    $job = Job::load($jobId);
    $requestData = json_decode($request->getContent(), true);
    $translator_plugin = $job->getTranslatorPlugin();
    $translator_plugin->applyTranslations($job, $requestData);
    $data = array("success" => true, "jobId" => $jobId);
    $response = new JsonResponse($data);
    return $response;
  }

  public function getJobItems(Request $request, $jobId)
  {
    $job = Job::load($jobId);
    $job_items = $job->getItems();
    $job_item_list = [];
    foreach ($job_items as $job_item) {
      if (!$job_item->isActive()) continue;
      $resource_id = $job_item->getItemId();
      $item_type = $job_item->getItemType();

      $entity = null;
      try {
        $entity = $this->entityTypeManager->getStorage($item_type)->load($resource_id);
      }
      catch (\Exception $e) {
        $entity = null;
      }

      $job_item_list[] = [
        'resource_id' => $resource_id,
        'resource_type' => ($entity && method_exists($entity, 'bundle')) ? $entity->bundle() : $item_type,
        'job_item_id' => $job_item->id(),
        'content' => $job_item->getData(),
      ];
    }
    return new JsonResponse($job_item_list);
  }

}
