<?php

declare(strict_types=1);

namespace Drupal\Tests\toc_twig_filter\Kernel;

use Drupal\Core\Render\Markup;
use Drupal\KernelTests\KernelTestBase;
use Drupal\toc_api\Entity\TocType;
use Drupal\toc_api\TocManagerInterface;

/**
 * Test description.
 *
 * @group toc_api
 */
class TocTwigFilterTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'toc_api',
    'toc_twig_filter',
  ];

  /**
   * The TOC manager.
   *
   * @var \Drupal\toc_api\TocManagerInterface
   */
  protected TocManagerInterface $tocManager;

  /**
   * The TOC builder.
   *
   * @var \Drupal\toc_api\TocBuilderInterface
   */
  protected $tocBuilder;

  /**
   * The TOC twig extension.
   *
   * @var \Drupal\toc_twig_filter\Twig\TocTwigExtension
   */
  protected $tocTwigExtension;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('toc_type');
    $this->installConfig(['toc_api']);
    $this->tocManager = $this->container->get('toc_api.manager');
    $this->tocBuilder = $this->container->get('toc_api.builder');
    $this->tocTwigExtension = $this->container->get('toc_twig_filter.twig_extension');
  }

  /**
   * Tests that ToC doesn't produce duplicated IDs.
   *
   * @todo Convert to unit test and include in TocTest, once that is fixed.
   */
  public function testBuild(): void {
    $toc_source = <<<HTML
    <h2>Documents</h2>
    <p>
      Tests that ToC API doesn't get confused by the deprecated "name" attribute.
      It was present in the XHTML 1.0, see https://www.w3.org/TR/xhtml1/#h-4.10 ,
      but removed from XHTML 1.1 , see the list of included modules for it
      here https://www.w3.org/TR/xhtml11/doctype.html , and deprecated
      "Name Identification Module" description here
      https://www.w3.org/TR/xhtml-modularization/abstract_modules.html .
    </p>

    <h3>Documents heading 3</h3>

    <h4>Documents heading 4</h4>
    <p>It is important that existing ID comes after the heading here.</p>
    HTML;

    $toc_type = TocType::load('default');
    $toc = $this->tocManager->create('toc_twig_filter_test', $toc_source, $toc_type->getOptions());
    $expected = [
      'toc' => $this->tocBuilder->buildToc($toc),
      'content' => $this->tocBuilder->buildContent($toc),
    ];
    $filtered_string = $this->tocTwigExtension->build($toc_source);
    $this->assertEquals($expected, $filtered_string);
    $filtered_markup = $this->tocTwigExtension->build(Markup::create($toc_source));
    $this->assertEquals($expected, $filtered_markup);

    $toc_type = TocType::load('full');
    $toc = $this->tocManager->create('toc_twig_filter_test', $toc_source, $toc_type->getOptions());
    $expected = [
      'toc' => $this->tocBuilder->buildToc($toc),
      'content' => $this->tocBuilder->buildContent($toc),
    ];
    $filtered_string = $this->tocTwigExtension->build($toc_source, 'full');
    $this->assertEquals($expected, $filtered_string);

    $options = $toc_type->getOptions();
    $toc = $this->tocManager->create('toc_twig_filter_test', $toc_source, $options);
    $expected = [
      'toc' => $this->tocBuilder->buildToc($toc),
      'content' => $this->tocBuilder->buildContent($toc),
    ];
    $filtered_string = $this->tocTwigExtension->build($toc_source, $options);
    $this->assertEquals($expected, $filtered_string);
  }

}
