/**
 * @file
 * Initializes tocbot library with relevant settings.
 */

/* global tocbot */

(function ($, Drupal, once) {
  Drupal.behaviors.tocbot = {
    attach: function attachTocBot(context, settings) {
      once('tocbot', settings.tocbot.contentSelector, context).forEach(
        (element) => {
          const options = settings.tocbot;
          const content = document.querySelector(options.contentSelector);
          if (content === null) {
            return;
          }

          if (options.createAutoIds) {
            // Create automatic ids.
            const headings = content.querySelectorAll(options.headingSelector);
            const headingMap = {};

            Array.prototype.forEach.call(headings, function (heading) {
              const id = heading.id
                ? heading.id
                : heading.textContent
                    .trim()
                    .toLowerCase()
                    .split(' ')
                    .join('-')
                    .replace(/[!@#$%^&*():?]/gi, '');
              headingMap[id] = !Number.isNaN(headingMap[id])
                ? ++headingMap[id]
                : 0;
              if (headingMap[id]) {
                heading.id = `${id}-${headingMap[id]}`;
              } else {
                heading.id = id;
              }
            });
          }

          const headings = $(options.contentSelector)
            .find(':header')
            .not(options.ignoreSelector);
          if (
            $(options.tocSelector).length &&
            headings.length >= parseInt(options.minActivate, 10)
          ) {
            // Activate.
            if (options.extraBodyClass.length > 0) {
              $('body').addClass(options.extraBodyClass);
            }

            // Fix tocbot offsettop bug.
            if (options.fixedSidebarOffset === 'auto') {
              let element = document.querySelector(options.tocSelector);
              let yPosition = 0;
              while (element) {
                yPosition +=
                  element.offsetTop - element.scrollTop + element.clientTop;
                element = element.offsetParent;
              }
              options.fixedSidebarOffset = yPosition;
            }

            // Make sure minActivate is an integer.
            options.minActivate = parseInt(options.minActivate, 10);
            // Make sure collapseDepth is an integer.
            options.collapseDepth = parseInt(options.collapseDepth, 10);
            // Make sure scrollSmoothDuration is an integer.
            options.scrollSmoothDuration = parseInt(
              options.scrollSmoothDuration,
              10,
            );
            // Make sure scrollSmoothOffset is an integer.
            options.scrollSmoothOffset = parseInt(
              options.scrollSmoothOffset,
              10,
            );
            // Make sure headingsOffset is an integer.
            options.headingsOffset = parseInt(options.headingsOffset, 10);
            // Make sure fixedSidebarOffset is an integer.
            options.fixedSidebarOffset = parseInt(
              options.fixedSidebarOffset,
              10,
            );
            // Make sure throttleTimeout is an integer.
            options.throttleTimeout = parseInt(options.throttleTimeout, 10);

            // Initialize tocbot.
            tocbot.init(options);
          }
        },
      );
    },
  };
})(jQuery, Drupal, once);
