<?php

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\ContentEntityTypeInterface;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\field\FieldStorageConfigInterface;

/**
 * Implements hook_field_views_data_alter().
 */
function token_aware_views_field_field_views_data_alter(array &$data, FieldStorageConfigInterface $field_storage): void {
  if ($data && $field_storage->getType() === 'metatag') {
    foreach ($data as $table => $table_data) {
      foreach ($table_data as $field => $field_data) {
        if (isset($field_data['field'])) {
          $data[$table][$field]['field']['id'] = 'token_aware_views_field';
        }
      }
    }
  }
}

/**
 * Implements hook_views_data()
 */
function token_aware_views_field_views_data() {
  $data = [];
  foreach (\Drupal::entityTypeManager()->getDefinitions() as $entity_type) {
    if (!is_a($entity_type->getClass(), ContentEntityInterface::class, TRUE)) {
      continue;
    }
    $tables = [];
    $base_table = $entity_type->getBaseTable() ?: $entity_type->id();
    $data_table = '';
    $translatable = $entity_type->isTranslatable();
    if ($translatable) {
      $data_table = $entity_type->getDataTable() ?: $entity_type->id() . '_field_data';
    }
    $views_base_table = $base_table;
    if ($data_table) {
      $views_base_table = $data_table;
    }
    $tables[] = $views_base_table;
    $revision_data_table = '';
    $revisionable = $entity_type->isRevisionable();
    if ($revisionable && $translatable) {
      $revision_data_table = $entity_type->getRevisionDataTable() ?: $entity_type->id() . '_field_revision';
    }
    $revision_table = '';
    if ($revisionable) {
      $revision_table = $entity_type->getRevisionTable() ?: $entity_type->id() . '_revision';
    }
    $views_revision_base_table = $revision_table;
    if ($revision_data_table) {
      $views_revision_base_table = $revision_data_table;
    }
    $tables[] = $views_revision_base_table;
    foreach ($tables as $table) {
      if ($table) {
        $data[$table]['token_aware_views_field'] = [
          'title' => t('Token aware field'),
          'field' => [
            'id' => 'token_aware_views_field',
          ],
        ];
      }
    }
  }
  return $data;
}
