<?php

namespace Drupal\Tests\token_browser\Functional;

use Drupal\Tests\token\Functional\TokenTestBase;
use Drupal\Tests\token\Functional\Tree\TokenTreeTestTrait;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the token tree on the help page.
 */
#[Group('token_browser')]
#[RunTestsInSeparateProcesses]
class HelpPageTest extends TokenTestBase {

  use TokenTreeTestTrait;

  /**
   * The user to use for testing.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $account;

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['help', 'path', 'token', 'token_browser', 'token_browser_module_test'];

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $permissions = ['access help pages'];
    $this->account = $this->drupalCreateUser($permissions);
    $this->drupalLogin($this->account);
  }

  /**
   * Tests the token browser on the token help page.
   */
  public function testHelpPageTree() {
    $this->drupalGet('admin/help/token_browser');
    $this->assertSession()->pageTextContains('The list of the currently available tokens on this site are shown below.');

    $this->assertTokenGroup('Current date');
    $this->assertTokenGroup('Site information');

    $this->assertTokenInTree('[current-date:html_date]', 'current-date');
    $this->assertTokenInTree('[current-date:html_week]', 'current-date');
    $this->assertTokenInTree('[date:html_date]', 'date');
    $this->assertTokenInTree('[date:html_week]', 'date');

    $this->assertTokenInTree('[current-user:account-name]', 'current-user');
    $this->assertTokenInTree('[user:account-name]', 'user');

    // Assert that deeper than level 1 tokens are not shown.
    $this->assertTokenNotInTree('[current-page:url:unaliased]', 'current-page--url');
    $this->assertTokenNotInTree('[current-page:url:unaliased:args]', 'current-page--url--unaliased');
    $this->assertTokenNotInTree('[user:original:account-name]', 'user--original');

    // Assert some of the restricted tokens to ensure they are shown.
    $this->assertTokenInTree('[user:one-time-login-url]', 'user');
    // Assert that deeper than level 1 tokens are not shown.
    $this->assertTokenNotInTree('[user:original:cancel-url]', 'user--original');

    // The Array token is marked as nested, so it should not show up as a top
    // level token, only nested under another token. For instance, user:roles
    // is of type Array and tokens of type Array have 'nested' setting true.
    $this->assertTokenNotGroup('Array');
    $this->assertTokenNotGroup('user:roles');
    $this->assertTokenInTree('[user:roles]', 'user');
  }

}
