CONTENTS OF THIS FILE
---------------------

* Introduction
* Recommended modules
* Installation
* Configuration
* For developers

INTRODUCTION
------------

Provides an alternative token browser for the Token module that allows
selecting tokens from any depth level. Visit the help section for this module
when enabled to see all available tokens for your site.

* To submit bug reports and feature suggestions or to track changes:
  https://drupal.org/project/issues/token_browser

RECOMMENDED MODULES
-------------------

* No extra module is required other than the Token module. Other
  modules may be considerably more useful when they use this Token Browser vs.
  the default provided by the Token module due to the performance benefits and
  the ability to select tokens from any depth level.

INSTALLATION
------------

* Install as usual, see
  https://www.drupal.org/docs/extending-drupal/installing-modules for further
  information.

CONFIGURATION
-------------

* No configuration is needed.

FOR DEVELOPERS
-------------

Developers can replace the `token_tree_link` theme hook with 
`token_browser_link`.
Avoid setting the `#recursion_limit` property as the default value is 1 and deeper
levels will be generated dynamically via HTMX.

Example implementation:

```
$form['tokens'] = [
  '#theme' => 'token_browser_link',
  '#token_types' => ['node', 'user'],
  '#global_types' => TRUE,
  '#click_insert' => TRUE,
  '#show_restricted' => FALSE,
];
