<?php

declare(strict_types=1);

namespace Drupal\token_browser;

use Drupal\token\TreeBuilder;

/**
 * Extends the tree builder from Token module for additional functionality.
 */
class TokenBrowserTreeBuilder extends TreeBuilder implements TokenBrowserTreeBuilderInterface {

  /**
   * {@inheritdoc}
   */
  public function buildRenderable(array $token_types, array $options = []): array {
    // Set default options.
    $options += [
      'global_types' => TRUE,
      'click_insert' => TRUE,
      'show_restricted' => FALSE,
      'show_nested' => FALSE,
      'recursion_limit' => 1,
    ];

    $info = $this->tokenService->getInfo();
    if ($options['global_types']) {
      $token_types = array_merge($token_types, $this->tokenService->getGlobalTokenTypes());
    }

    $element = [];

    // @todo Find a way to use the render cache for this.
    $tree_options = [
      'flat' => TRUE,
      'restricted' => $options['show_restricted'],
      'nested' => $options['show_nested'],
      'depth' => $options['recursion_limit'],
    ];

    $token_tree = [];
    foreach ($info['types'] as $type => $type_info) {
      if (!in_array($type, $token_types)) {
        continue;
      }

      $token_tree[$type] = $type_info;
      $token_tree[$type]['tokens'] = $this->buildTree($type, $tree_options);
    }

    $element += [
      '#type' => 'token_browser_tree_table',
      '#token_tree' => $token_tree,
      '#show_restricted' => $options['show_restricted'],
      '#show_nested' => $options['show_nested'],
      '#click_insert' => $options['click_insert'],
      '#columns' => ['name', 'token', 'description'],
      '#empty' => $this->t('No tokens available'),
    ];

    return $element;
  }

}
