<?php

namespace Drupal\token_eca_alter\Service;

use Drupal\eca\Event\TriggerEvent;
use Drupal\token_eca_alter\Events\TokenAlterEvent;

/**
 * Hook Handler for Token ECA Alter.
 *
 * @package Drupal\token_eca_alter\Service
 */
class HookHandler {

  /**
   * The service for triggering ECA-related events.
   *
   * @var \Drupal\eca\Event\TriggerEvent
   */
  protected TriggerEvent $triggerEvent;

  /**
   * The HookHandler constructor.
   *
   * @param \Drupal\eca\Event\TriggerEvent $trigger_event
   *   The service for triggering ECA-related events.
   */
  public function __construct(TriggerEvent $trigger_event) {
    $this->triggerEvent = $trigger_event;
  }

  /**
   * Alter the exist token.
   *
   * @param string $key
   *   The alter key.
   * @param string $token
   *   Exist token.
   * @param string $data
   *   The token data.
   * @param array $options
   *   The alter options.
   *
   * @return string
   *   Alter token result.
   */
  public function ecaAlter(string $key, string $token, string $data, array $options = []): string {
    /** @var \Drupal\token_eca_alter\Events\TokenAlterEvent $event */
    $event = $this->triggerEvent->dispatchFromPlugin('token_eca_alter:callback', $key, $token, $data, $options);
    if (!($event instanceof TokenAlterEvent)) {
      return '';
    }
    return $event->getData();
  }

}
