<?php

namespace Drupal\token_modifier\Plugin\token_modifier;

use Drupal\token_modifier\Plugin\TokenModifierPluginBase;

/**
 * Limit the maximum length of the token.
 *
 * @TokenModifier(
 *   id = "length",
 *   name = @Translation("Length"),
 *   description = @Translation("Limit the maximum length of the returned string.")
 * )
 */
class Length extends TokenModifierPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform(string $text, array $data = [], array $options = []) {
    $token_string = substr($text, 1, -1);
    $parts = explode(':', $token_string);
    $length = (int) array_shift($parts);
    $token = implode(':', $parts);
    $string = $this->token->replace("[$token]", $data, $options);
    return substr($string, 0, $length);
  }

}
