<?php

namespace Drupal\token_modifier\Plugin\token_modifier;

use Drupal\token_modifier\Plugin\TokenModifierPluginBase;

/**
 * Removes Html tags from the token.
 *
 * @TokenModifier(
 *   id = "strip-tags",
 *   name = @Translation("Strip tags"),
 *   description = @Translation("Removes the Html tags")
 * )
 */
class StripTags extends TokenModifierPluginBase {

  public function transform(string $text, array $data = [], array $options = []) {
    return strip_tags($this->token->replace($text, $data, $options));
  }

}

