<?php

namespace Drupal\Tests\token_modifier\Unit;

use Drupal\token_modifier\Plugin\token_modifier\Lowercase;

class LowercaseTest extends TokenModifierTestCase {

  /**
   * Tests the Lowercase token modifier.
   *
   * @param string $value
   *   The source value for the modifier.
   * @param string $expected
   *   The expected result.
   *
   * @covers ::transform
   *
   * @dataProvider providerTestTransform
   */
  public function testTransform(string $value, string $expected) {
    $plugin = new Lowercase([], 'lowercase', [], $this->token);
    $actual = $plugin->transform($value);
    $this->assertSame($expected, $actual);
  }

  /**
   * Provides data for testTransform.
   */
  public static function providerTestTransform(): array {
    $data['basic'] = ['Hello World!', 'hello world!'];
    $data['already lowercased'] = ['working?', 'working?'];
    $data['capitalised'] = ['CAPITALISED', 'capitalised'];
    $data['multibyte'] = ['AČIŪ', 'ačiū'];
    return $data;
  }

}
