<?php

namespace Drupal\token_modifier\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Token Modifier annotation object.
 *
 * @see \Drupal\token_modifier\Plugin\TokenModifierPluginManager
 * @see \Drupal\token_modifier\Plugin\TokenModifierInterface
 * @see \Drupal\token_modifier\Plugin\TokenModifierPluginBase
 *
 * @Annotation
 */
class TokenModifier extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The name of the plugin.
   *
   * @ingroup plugin_translatable
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $name;

  /**
   * A description of the plugin.
   *
   * @ingroup plugin_translatable
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $description;

}
