<?php

namespace Drupal\token_modifier\Plugin\token_modifier;

use Drupal\token_modifier\Plugin\TokenModifierPluginBase;

/**
 * Makes all characters of the token lowercase.
 *
 * @TokenModifier(
 *   id = "lowercase",
 *   name = @Translation("Lowercase"),
 *   description = @Translation("Lowercase the returned string.")
 * )
 */
class Lowercase extends TokenModifierPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform(string $text, array $data = [], array $options = []) {
    return mb_strtolower($this->token->replace($text, $data, $options));
  }

}
