<?php

namespace Drupal\Tests\token_modifier\Unit;

use Drupal\token_modifier\Plugin\token_modifier\Length;

class LengthTest extends TokenModifierTestCase {

  /**
   * Tests the Length token modifier.
   *
   * @param string $value
   *   The source value for the modifier.
   * @param string $expected
   *   The expected result.
   *
   * @covers ::transform
   *
   * @dataProvider providerTestTransform
   */
  public function testTransform(string $value, string $expected) {
    $value = "[$value]";
    $plugin = new Length([], 'length', [], $this->token);
    $actual = $plugin->transform($value);
    $this->assertSame($expected, $actual);
  }

  /**
   * Provides data for testTransform.
   */
  public function providerTestTransform(): array {
    $data['basic'] = ['12:Hello world!', 'Hello world!'];
    $data['shorter than string'] = ['5:Hello world!', 'Hello'];
    $data['longer than string'] = ['24:Hello world!', 'Hello world!'];
    return $data;
  }

}
