<?php

namespace Drupal\Tests\token_modifier\Unit;

use Drupal\Tests\UnitTestCase;

abstract class TokenModifierTestCase extends UnitTestCase {

  /**
   * @var \Drupal\Core\Utility\Token|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $token;

  protected function setUp(): void {
    $this->token = $this->createMock('Drupal\Core\Utility\Token');
    $this->token->method('replace')->willReturnCallback(function(string $token) {
      return preg_replace('/(^\[|\]$)/', '', $token);
    });

    parent::setUp();
  }

}
