<?php

namespace Drupal\Tests\token_modifier\Unit;

use Drupal\token_modifier\Plugin\token_modifier\UpperCaseFirst;

class UpperCaseFirstTest extends TokenModifierTestCase {

  /**
   * Tests the Upper Case First token modifier.
   *
   * @param string $value
   *   The source value for the modifier.
   * @param string $expected
   *   The expected result.
   *
   * @covers ::transform
   *
   * @dataProvider providerTestTransform
   */
  public function testTransform(string $value, string $expected) {
    $plugin = new UpperCaseFirst([], 'upper-case-first', [], $this->token);
    $actual = $plugin->transform($value);
    $this->assertSame($expected, $actual);
  }

  /**
   * Provides data for testTransform.
   */
  public static function providerTestTransform(): array {
    $data['basic'] = ['hello world!', 'Hello world!'];
    $data['already capitalised'] = ['Working?', 'Working?'];
    $data['everything else capitalised'] = ['cAPITALISE', 'CAPITALISE'];
    $data['multibyte'] = ['čhecking multibyte ūnderway...', 'Čhecking multibyte ūnderway...'];
    return $data;
  }

}
