# Token Modifier

Provides a meta token that allows the modification of the output of other tokens.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/token_modifier).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/token_modifier).

## Requirements

Metatag Link Preview requires the following module(s):

- [Token](https://www.drupal.org/project/token)


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Enable the module at Administration » Extend.
2. All Token Modifier plugins are available


## Included modifiers

### `urlencode`

URL Encodes the returned string.

e.g. `[token-modifier:urlencode:current-user:name]`

### `title-case`

Uppercases the first letter of each word using ucwords.

e.g. `[token-modifier:title-case:current-user:name]`

### `sentence-case`

Uppercases the first letter of each sentence.

e.g. `[token-modifier:sentence-case:current-user:name]`

### `uppercase`

Uppercases all characters.

e.g. `[token-modifier:uppercase:current-user:name]`

### `lowercase`

Lowercases all characters.

e.g. `[token-modifier:lowercase:current-user:name]`

### `uppercase-first`

Uppercases the first letter of the string.

e.g. `[token-modifier:uppercase-first:current-user:name]`

### `length:{no-of-chars}`

Limits the maximum length of the string.

e.g. `[token-modifier:length:4:current-user:name]`  
hello world » hell


## Maintainers

- Jo Fitzgerald - [jofitz](https://www.drupal.org/u/jofitz)
