<?php

namespace Drupal\token_modifier\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * An interface for Token Modifier plugins.
 */
interface TokenModifierInterface extends PluginInspectionInterface {

  /**
   * Performs the associated process.
   *
   * @param string $text
   *   An string containing replaceable tokens.
   * @param array $data
   *   (optional) An array of keyed objects.
   * @param array $options
   *   (optional) A keyed array of settings and flags to control the token
   *   replacement process.
   *
   * @return mixed
   */
  public function transform(string $text, array $data = [], array $options = []);

}
