<?php

namespace Drupal\token_modifier\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

class TokenModifierPluginManager extends DefaultPluginManager {
  /**
   * Constructs a TokenModifierPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/token_modifier', $namespaces, $module_handler, 'Drupal\token_modifier\Plugin\TokenModifierInterface', 'Drupal\token_modifier\Annotation\TokenModifier');
    $this->alterInfo('token_modifier_info');
    $this->setCacheBackend($cache_backend, 'token_modifier_plugins');
  }

  /**
   * Returns the token modifiers.
   *
   * @return TokenModifierInterface[]
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public function getModifiers() : array {
    $modifiers = [];
    foreach ($this->getDefinitions() as $plugin_id => $definition) {
      $modifiers[] = $this->createInstance($plugin_id);
    }
    return $modifiers;
  }

}
