<?php

namespace Drupal\token_modifier\Plugin\token_modifier;

use Drupal\token_modifier\Plugin\TokenModifierPluginBase;

/**
 * Strips whitespace from the beginning of a string.
 *
 * @TokenModifier(
 *   id = "ltrim",
 *   name = @Translation("Ltrim"),
 *   description = @Translation("Strips whitespace from the beginning of a string.")
 * )
 */
class Ltrim extends TokenModifierPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform(string $text, array $data = [], array $options = []) {
    return ltrim($this->token->replace($text, $data, $options));
  }

}
