<?php

namespace Drupal\token_modifier\Plugin\token_modifier;

use Drupal\token_modifier\Plugin\TokenModifierPluginBase;

/**
 * Strips whitespace from the end of a string.
 *
 * @TokenModifier(
 *   id = "rtrim",
 *   name = @Translation("Rtrim"),
 *   description = @Translation("Strips whitespace from the end of a string.")
 * )
 */
class Rtrim extends TokenModifierPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform(string $text, array $data = [], array $options = []) {
    return rtrim($this->token->replace($text, $data, $options));
  }

}
