<?php

namespace Drupal\token_modifier\Plugin\token_modifier;

use Drupal\token_modifier\Plugin\TokenModifierPluginBase;

/**
 * Strips whitespace from the beginning and end of a string.
 *
 * @TokenModifier(
 *   id = "trim",
 *   name = @Translation("Trim"),
 *   description = @Translation("Strips whitespace from the beginning and end of a string.")
 * )
 */
class Trim extends TokenModifierPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform(string $text, array $data = [], array $options = []) {
    return trim($this->token->replace($text, $data, $options));
  }

}
