<?php

namespace Drupal\token_modifier\Plugin\token_modifier;

use Drupal\token_modifier\Plugin\TokenModifierPluginBase;

/**
 * Makes all characters of the string uppercase.
 *
 * @TokenModifier(
 *   id = "uppercase",
 *   name = @Translation("Upper case"),
 *   description = @Translation("Uppercases all characters.")
 * )
 */
class UpperCase extends TokenModifierPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform(string $text, array $data = [], array $options = []) {
    return mb_strtoupper($this->token->replace($text, $data, $options));
  }

}
