<?php

namespace Drupal\token_modifier\Plugin\token_modifier;

use Drupal\token_modifier\Plugin\TokenModifierPluginBase;

/**
 * URL Encodes the returned string.
 *
 * @TokenModifier(
 *   id = "urlencode",
 *   name = @Translation("URL Encode"),
 *   description = @Translation("URL Encodes the returned string.")
 * )
 */
class Urlencode extends TokenModifierPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform(string $text, array $data = [], array $options = []) {
    return urlencode($this->token->replace($text, $data, $options));
  }

}
