<?php

namespace Drupal\Tests\token_modifier\Unit;

use Drupal\token_modifier\Plugin\token_modifier\Ltrim;

class LtrimTest extends TokenModifierTestCase {

  /**
   * Tests the Ltrim token modifier.
   *
   * @param string $value
   *   The source value for the modifier.
   * @param string $expected
   *   The expected result.
   *
   * @covers ::transform
   *
   * @dataProvider providerTestTransform
   */
  public function testTransform(string $value, string $expected) {
    $plugin = new Ltrim([], 'ltrim', [], $this->token);
    $actual = $plugin->transform($value);
    $this->assertSame($expected, $actual);
  }

  /**
   * Provides data for testTransform.
   */
  public static function providerTestTransform(): array {
    $data['basic'] = [' Hello World! ', 'Hello World! '];
    $data['no spaces'] = ['no spaces', 'no spaces'];
    $data['leading space'] = [' leading', 'leading'];
    $data['trailing space'] = ['trailing ', 'trailing '];
    return $data;
  }

}
