<?php

namespace Drupal\Tests\token_modifier\Unit;

use Drupal\token_modifier\Plugin\token_modifier\Rtrim;

class RtrimTest extends TokenModifierTestCase {

  /**
   * Tests the Rtrim token modifier.
   *
   * @param string $value
   *   The source value for the modifier.
   * @param string $expected
   *   The expected result.
   *
   * @covers ::transform
   *
   * @dataProvider providerTestTransform
   */
  public function testTransform(string $value, string $expected) {
    $plugin = new Rtrim([], 'rtrim', [], $this->token);
    $actual = $plugin->transform($value);
    $this->assertSame($expected, $actual);
  }

  /**
   * Provides data for testTransform.
   */
  public static function providerTestTransform(): array {
    $data['basic'] = [' Hello World! ', ' Hello World!'];
    $data['no spaces'] = ['no spaces', 'no spaces'];
    $data['leading space'] = [' leading', ' leading'];
    $data['trailing space'] = ['trailing ', 'trailing'];
    return $data;
  }

}
