<?php

namespace Drupal\Tests\token_modifier\Unit;

use Drupal\token_modifier\Plugin\token_modifier\StripTags;

class StripTagsTest extends TokenModifierTestCase {

  /**
   * Tests the Strip Tags token modifier.
   *
   * @param string $value
   *   The source value for the modifier.
   * @param string $expected
   *   The expected result.
   *
   * @covers ::transform
   *
   * @dataProvider providerTestTransform
   */
  public function testTransform(string $value, string $expected) {
    $plugin = new StripTags([], 'strip-tags', [], $this->token);
    $actual = $plugin->transform($value);
    $this->assertSame($expected, $actual);
  }

  /**
   * Provides data for testTransform.
   */
  public static function providerTestTransform(): array {
    $data['basic'] = ['<p>Hello world!</p>', 'Hello world!'];
    $data['already stripped'] = ['Working?', 'Working?'];
    $data['multiple tags'] = ['<h1>Title</h1> <p>Here\'s a sentence</p>', 'Title Here\'s a sentence'];
    $data['nested tags'] = ['<p>Here\'s an <b>important</b> word</p>', 'Here\'s an important word'];
    return $data;
  }

}
