<?php

namespace Drupal\Tests\token_modifier\Unit;

use Drupal\token_modifier\Plugin\token_modifier\TitleCase;

class TitleCaseTest extends TokenModifierTestCase {

  /**
   * Tests the Title Case token modifier.
   *
   * @param string $value
   *   The source value for the modifier.
   * @param string $expected
   *   The expected result.
   *
   * @covers ::transform
   *
   * @dataProvider providerTestTransform
   */
  public function testTransform(string $value, string $expected) {
    $plugin = new TitleCase([], 'title-case', [], $this->token);
    $actual = $plugin->transform($value);
    $this->assertSame($expected, $actual);
  }

  /**
   * Provides data for testTransform.
   */
  public static function providerTestTransform(): array {
    $data['basic'] = ['hello world!', 'Hello World!'];
    $data['already capitalised'] = ['It\'s Working?', 'It\'s Working?'];
    $data['everything else capitalised'] = ['cAPITALISE eVERYTHING', 'CAPITALISE EVERYTHING'];
    $data['multibyte'] = ['čhecking multibyte ūnderway...', 'Čhecking Multibyte Ūnderway...'];
    return $data;
  }

}
