<?php

namespace Drupal\Tests\token_modifier\Unit;

use Drupal\token_modifier\Plugin\token_modifier\UpperCase;

class UpperCaseTest extends TokenModifierTestCase {

  /**
   * Tests the Upper Case token modifier.
   *
   * @param string $value
   *   The source value for the modifier.
   * @param string $expected
   *   The expected result.
   *
   * @covers ::transform
   *
   * @dataProvider providerTestTransform
   */
  public function testTransform(string $value, string $expected) {
    $plugin = new UpperCase([], 'uppercase', [], $this->token);
    $actual = $plugin->transform($value);
    $this->assertSame($expected, $actual);
  }

  /**
   * Provides data for testTransform.
   */
  public static function providerTestTransform(): array {
    $data['basic'] = ['hello world!', 'HELLO WORLD!'];
    $data['already capitalised'] = ['WORKING?', 'WORKING?'];
    $data['camel case'] = ['cApItAlIsE', 'CAPITALISE'];
    $data['multibyte'] = ['ačiū', 'AČIŪ'];
    return $data;
  }

}
