<?php

namespace Drupal\Tests\token_modifier\Unit;

use Drupal\token_modifier\Plugin\token_modifier\Urlencode;

class UrlencodeTest extends TokenModifierTestCase {

  /**
   * Tests the URL Encode token modifier.
   *
   * @param string $value
   *   The source value for the modifier.
   * @param string $expected
   *   The expected result.
   *
   * @covers ::transform
   *
   * @dataProvider providerTestTransform
   */
  public function testTransform(string $value, string $expected) {
    $plugin = new Urlencode([], 'urlencode', [], $this->token);
    $actual = $plugin->transform($value);
    $this->assertSame($expected, $actual);
  }

  /**
   * Provides data for testTransform.
   */
  public static function providerTestTransform(): array {
    $data['basic'] = ['hello world!', 'hello+world%21'];
    $data['urlencode not required'] = ['hello', 'hello'];
    $data['already urlencoded'] = ['hello+world%21', 'hello%2Bworld%2521'];
    return $data;
  }

}
