<?php

declare(strict_types=1);

namespace Drupal\tool_content\Plugin\tool\Tool;

use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\tool\TypedData\InputDefinition;
use Drupal\tool\Attribute\Tool;
use Drupal\tool\ExecutableResult;
use Drupal\tool_entity\Plugin\tool\Tool\EntityBundleFieldDefinitions;

/**
 * Plugin implementation of the field definitions by entity tool.
 */
#[Tool(
  id: 'entity_field_definitions',
  label: new TranslatableMarkup('Entity Field Definitions'),
  description: new TranslatableMarkup('Get field definitions and value schema for a given entity.'),
  input_definitions: [
    'entity' => new InputDefinition(
      data_type: 'entity',
      label: new TranslatableMarkup("Entity"),
      description: new TranslatableMarkup("The entity to get field definitions for.")
    ),
  ],
  output_definitions: [
    'field_definitions' => new ContextDefinition(
      data_type: 'map',
      label: new TranslatableMarkup("Field Definitions"),
      description: new TranslatableMarkup("Array of field definitions with metadata and example values.")
    ),
  ],
)]
final class EntityFieldDefinitions extends EntityBundleFieldDefinitions {

  /**
   * {@inheritdoc}
   */
  protected function doExecute(array $values): ExecutableResult {
    ['entity' => $entity] = $values;
    return parent::doExecute([
      'entity_type_id' => $entity->getEntityTypeId(),
      'bundle' => $entity->bundle()
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function checkAccess(array $values, ?AccountInterface $account = NULL, $return_as_object = FALSE): bool|AccessResultInterface {
    ['entity' => $entity] = $values;
    return parent::checkAccess([
      'entity_type_id' => $entity->getEntityTypeId(),
      'bundle' => $entity->bundle()
    ], $account, $return_as_object); // TODO: Change the autogenerated stub
  }

}
