<?php

namespace Drupal\tool\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\SubformState;
use Drupal\Core\TypedData\TypedDataTrait;

class ExecuteToolPluginForm extends ToolPluginFormBase {
  use TypedDataTrait;
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    foreach ($this->plugin->getContextDefinitions() as $name => $definition) {
      $form[$name] = [];
      $subform_state = SubformState::createForSubform($form[$name], $form, $form_state);
      $form[$name] += $this->plugin->getFormElement($name, $form[$name], $subform_state);
    }
    return $form;
    // TODO: Implement buildConfigurationForm() method.
  }

  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    foreach ($this->plugin->getContextDefinitions() as $name => $definition) {
        $data = $this->getTypedDataManager()->create($definition->getDataDefinition(), null);
        $form_widget_plugin = $this->plugin->getFormWidgetInstance($name);
        $subform_state = SubformState::createForSubform($form[$name], $form, $form_state);
        $form_widget_plugin->extractFormValues($data, $subform_state);
        $this->plugin->setContextValue($name, $data->getValue());
    }
    $this->plugin->execute();
    \Drupal::messenger()->addMessage($this->plugin->getResultMessage());
  }
}
