<?php

declare(strict_types=1);

namespace Drupal\tool\Plugin\tool\TypedData\SchemaWidget;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\SubformState;
use Drupal\Core\Form\SubformStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\DataDefinitionInterface;
use Drupal\Core\TypedData\ListDataDefinitionInterface;
use Drupal\Core\TypedData\TypedDataInterface;
use Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetBase;
use Drupal\tool\Attribute\TypedDataSchemaWidget;
use Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetTrait;
use Symfony\Component\Validator\ConstraintViolationListInterface;

/**
 * Plugin implementation for handling multiple values (lists).
 */
#[TypedDataSchemaWidget(
  id: 'list',
  label: new TranslatableMarkup('List'),
  description: new TranslatableMarkup('Widget for handling multiple values in list data types.'),
  data_types: ['list'],
  weight: -10, // Higher priority for list items
)]
final class ListWidget extends TypedDataSchemaWidgetBase {

  use TypedDataSchemaWidgetTrait;

  /**
   * {@inheritdoc}
   */
  public function formElement(TypedDataInterface $data, array $element, SubformStateInterface $form_state): array {
    $form = [];
//    $list_definition = $data->getDataDefinition();
//    $item_definition = $list_definition->getItemDefinition();
//
//    // Get current values
//    $values = [];
//    foreach ($data as $delta => $item) {
//      $values[$delta] = $item;
//    }
//
//    // Add an empty item for new entries if the list isn't at max capacity
//    $max_items = $list_definition->getSetting('max_items') ?? NULL;
//    if ($max_items === NULL || count($values) < $max_items) {
//      $new_item = $data->getItemDefinition()->getClass()::createInstance($item_definition);
//      $values[] = $new_item;
//    }
//
//    $form['#tree'] = TRUE;
//    $form['#type'] = 'fieldset';
//    $form['#title'] = $list_definition->getLabel();
//    $form['#description'] = $list_definition->getDescription();
//
//    // Create form elements for each item
//    foreach ($values as $delta => $item) {
//      $form['items'][$delta] = [
//        '#type' => 'container',
//      ];
//
//      // Get the appropriate widget for the item type
//      $item_widget = $this->getSchemaWidgetInstance($item_definition, "items][{$delta}");
//      $item_form_state = SubformState::createForSubform( $form['items'][$delta], $form, $form_state);
//
//      $form['items'][$delta]['value'] = $item_widget->formElement($item, $item_form_state);
//
//      // Add remove button for existing items (except the last empty one)
//      if ($delta < count($values) - 1 || ($max_items !== NULL && count($values) >= $max_items)) {
//        $form['items'][$delta]['remove'] = [
//          '#type' => 'submit',
//          '#value' => $this->t('Remove'),
//          '#name' => "remove_item_{$delta}",
//          '#submit' => [[$this, 'removeItem']],
//          '#ajax' => [
//            'callback' => [$this, 'ajaxCallback'],
//            'wrapper' => 'list-widget-wrapper',
//          ],
//          '#delta' => $delta,
//        ];
//      }
//    }
//
//    // Add "Add more" button if not at max capacity
//    if ($max_items === NULL || count($values) - 1 < $max_items) {
//      $form['add_more'] = [
//        '#type' => 'submit',
//        '#value' => $this->t('Add another item'),
//        '#submit' => [[$this, 'addMore']],
//        '#ajax' => [
//          'callback' => [$this, 'ajaxCallback'],
//          'wrapper' => 'list-widget-wrapper',
//        ],
//      ];
//    }
//
//    $form['#prefix'] = '<div id="list-widget-wrapper">';
//    $form['#suffix'] = '</div>';

    return $form;
  }

  /**
   * Submit handler for "Add more" button.
   */
  public function addMore(array &$form, SubformStateInterface $form_state): void {
    // Trigger form rebuild to add another item
    $form_state->setRebuild();
  }

  /**
   * Submit handler for "Remove" button.
   */
  public function removeItem(array &$form, SubformStateInterface $form_state): void {
    $triggering_element = $form_state->getTriggeringElement();
    $delta = $triggering_element['#delta'];

    // Get current values and remove the specified item
    $values = $form_state->getValue('items', []);
    unset($values[$delta]);

    // Re-index the array
    $values = array_values($values);

    // Update form state
    $form_state->setValue('items', $values);
    $form_state->setRebuild();
  }

  /**
   * AJAX callback for add/remove operations.
   */
  public function ajaxCallback(array &$form, SubformStateInterface $form_state): array {
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function extractFormValues(TypedDataInterface $data, FormStateInterface $form_state): void {
    $items = $form_state->getValue('items', []);

    // Clear existing list
    while (!$data->isEmpty()) {
      $data->removeItem(0);
    }

    // Add new items
    foreach ($items as $delta => $item_data) {
      if (!empty($item_data['value']) || (is_array($item_data['value']) && !empty(array_filter($item_data['value'])))) {
        // Create new list item
        $item = $data->appendItem();

        // Get the widget for this item type and extract its value
        $item_definition = $data->getItemDefinition();
        $item_widget = $this->getSchemaWidgetInstance($item_definition, "items][{$delta}");

        // Create subform state for the item
        $item_form_state = $form_state->createSubFormState(['items', $delta], $form_state->getFormObject());

        // Extract the value using the item's widget
        $item_widget->extractFormValues($item, $item_form_state);
      }
    }
  }

}
