<?php

declare(strict_types=1);

namespace Drupal\tool\Tool;


use Drupal\Component\Plugin\Definition\PluginDefinitionInterface;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\tool\Attribute\Tool;
use Drupal\tool\TypedInputs;

/**
 * Tool plugin manager.
 */
final class ToolManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/tool/Tool', $namespaces, $module_handler, ToolInterface::class, Tool::class);
    $this->alterInfo('tool_info');
    $this->setCacheBackend($cache_backend, 'tool_plugins');
  }

    public function processDefinition(&$definition, $plugin_id) {
      parent::processDefinition($definition, $plugin_id);

      if ($definition instanceof ToolDefinition) {
        $forms = $definition->getForms();
        if (!isset($forms['configure'])) {
          $definition->addForm('configure', 'Drupal\tool\Form\ConfigureToolPluginForm');
        }
        if (!isset($forms['execute'])) {
          $definition->addForm('configure', 'Drupal\tool\Form\ExecuteToolPluginForm');
        }
        if (is_subclass_of($definition->getClass(), ConditionToolInterface::class)) {
          foreach ($definition->getClass()::defineOutputDefinitions() as $name => $output_definition) {
            $definition->addOutputDefinition($name, $output_definition);
          }
        }
      }
      elseif (is_array($definition) && isset($definition['class'])) {
        if (!isset($definition['forms']['configure'])) {
          $definition['forms']['configure'] = 'Drupal\tool\Form\ConfigureToolPluginForm';
        }
        if (!isset($definition['forms']['execute'])) {
          $definition['forms']['execute'] = 'Drupal\tool\Form\ExecuteToolPluginForm';
        }
        if (is_subclass_of($definition['class'], ConditionToolInterface::class)) {
          foreach ($definition->getClass()::defineOutputDefinitions() as $name => $output_definition) {
            $definition['output_definitions'][$name] = $output_definition;
          }
        }
      }
    }

}
