<?php

namespace Drupal\tool\TypedData;

use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\Plugin\Context\ContextDefinitionInterface;

class MapContextDefinition extends ContextDefinition {
  protected array $value_definitions = [];

  /**
   * Constructs a new context definition object.
   *
   * @param string $data_type
   *   The required data type.
   * @param string|null|\Stringable $label
   *   The label of this context definition for the UI.
   * @param bool $required
   *   Whether the context definition is required.
   * @param bool $multiple
   *   Whether the context definition is multivalue.
   * @param string|null $description
   *   The description of this context definition for the UI.
   * @param mixed $default_value
   *   The default value of this definition.
   * @param array $constraints
   *   An array of constraints keyed by the constraint name and a value of an
   *   array constraint options or a NULL.
   * @param ContextDefinitionInterface[] $value_definitions
   *   The definition for map values.
   */
  public function __construct($data_type = 'map', $label = NULL, $required = TRUE, $multiple = FALSE, $description = NULL, $default_value = NULL, array $constraints = [], array $value_definitions = []) {
    parent::__construct('map', $label, $required, $multiple, $description, $default_value, $constraints);
    foreach ($value_definitions as $name => $value_definition) {
      if (!is_string($name)) {
        throw new \InvalidArgumentException('Value definition names must be strings.');
      }
      if (!$value_definition instanceof ContextDefinitionInterface) {
        throw new \InvalidArgumentException('Value definitions must be instances of ContextDefinitionInterface.');
      }
    }
    $this->value_definitions = $value_definitions;
  }

  public function setValueDefinitions(array $value_definitions): self {
    foreach ($value_definitions as $name => $value_definition) {
      if (!is_string($name)) {
        throw new \InvalidArgumentException('Value definition names must be strings.');
      }
      if (!$value_definition instanceof ContextDefinitionInterface) {
        throw new \InvalidArgumentException('Value definitions must be instances of ContextDefinitionInterface.');
      }
    }
    $this->value_definitions = $value_definitions;
    return $this;
  }

  public function getValueDefinition(): array {
    return $this->value_definitions;
  }

}
