<?php

declare(strict_types=1);

namespace Drupal\tool\Plugin\tool\TypedData\SchemaWidget;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\SubformStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\TypedDataInterface;
use Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetBase;
use Drupal\tool\Attribute\TypedDataSchemaWidget;

/**
 * Plugin implementation of the data_type_form_widget.
 */
#[TypedDataSchemaWidget(
  id: 'undefined',
  label: new TranslatableMarkup('Undefined'),
  description: new TranslatableMarkup('Foo description.'),
  data_types: [],
)]
final class UndefinedWidget extends TypedDataSchemaWidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(TypedDataInterface $data, array $element, SubformStateInterface $form_state): array {
    $form['content'] = [
      '#type' => 'markup',
      '#markup' => $this->t('This data type "%type" is not defined.', ['%type' => $data->getDataDefinition()->getDataType()]),
      '#disabled' => $data->getDataDefinition()->isReadOnly(),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function extractFormValues(TypedDataInterface $data, FormStateInterface $form_state): void {

  }

}
