<?php

namespace Drupal\tool\TypedData;

class MapInputDefinition extends MapContextDefinition implements InputDefinitionInterface {
  use InputDefinitionTrait;

  /**
   * Constructs a new context definition object.
   *
   * @param string $data_type
   *   The required data type.
   * @param string|null|\Stringable $label
   *   The label of this context definition for the UI.
   * @param bool $required
   *   Whether the context definition is required.
   * @param bool $multiple
   *   Whether the context definition is multivalue.
   * @param string|null $description
   *   The description of this context definition for the UI.
   * @param mixed $default_value
   *   The default value of this definition.
   * @param array $constraints
   *   An array of constraints keyed by the constraint name and a value of an
   *   array constraint options or a NULL.
   * @param bool $locked
   *   Whether the input is locked, meaning it cannot be changed by context or configuration.
   * @param array $form_alter
   *   An array of form properties or a callback to alter the form element.
   * @param array $config_schema_override
   *   An array of config schema definitions to override the default schema for this input.
   */
  public function __construct($data_type = 'any', $label = NULL, $required = TRUE, $multiple = FALSE, $description = NULL, $default_value = NULL, array $constraints = [],  $value_definitions = null, $locked = FALSE, $form_alter = [], $config_schema_override = []) {
    parent::__construct($data_type, $label, $required, $multiple, $description, $default_value, $constraints, $value_definitions);
    $this->isLocked = $locked;
    $this->formAlter = $form_alter;
    $this->configSchemaOverride = $config_schema_override;
  }

}
