<?php

namespace Drupal\tool;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\Context\ContextInterface as ComponentContextInterface;
use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\Core\Cache\Cache;
use Drupal\Core\Cache\CacheableDependencyInterface;
use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\Form\SubformStateInterface;
use Drupal\Core\Plugin\Context\Context;
use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\Plugin\Context\ContextInterface;
use Drupal\Core\Plugin\ContextAwarePluginTrait;
use Drupal\Core\TypedData\TypedData;
use Drupal\Core\TypedData\TypedDataTrait;
use Drupal\tool\Exception\InputException;
use Drupal\tool\TypedData\InputDefinitionInterface;
use Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetInterface;
use Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetPluginManager;
use Symfony\Component\Validator\ConstraintViolationList;

trait TypedInputsTrait {

  use DependencySerializationTrait;
  use TypedDataTrait;

  /**
   * @inheritdoc
   */
  public function getExecutableValues(): array {
    return $this->typedInputs->getExecutableValues();
  }

  /**
   * @inheritdoc
   */
  public function getInputDefinitions($include_locked = FALSE): array {
    return $this->typedInputs->getInputDefinitions($include_locked);
  }

  /**
   * @inheritdoc
   */
  public function getInputDefinition($name): InputDefinitionInterface|InputException {
    return $this->typedInputs->getInputDefinition($name);
  }

  /**
   * @inheritdoc
   */
  public function setInputValue($name, $value): self {
    $this->typedInputs->setInputValue($name, $value);
    return $this;
  }

  /**
   * @inheritdoc
   */
  public function validateInputs(): ConstraintViolationList {
    return $this->typedInputs->validateInputs();
  }

  /**
   * @deprecated
   */
  public function getFormWidgetInstance(string $name): TypedDataSchemaWidgetInterface {
    return $this->typedInputs->getFormWidgetInstance($name);
  }

  /**
   * @deprecated
   */
  public function getFormElement(string $name, &$element, SubformStateInterface $subform_state): array {
    return $this->typedInputs->getFormElement($name, $element, $subform_state);
  }

  /**
   * @inheritdoc
   */
  public function getConfiguration(): array {
    return $this->typedInputs->getConfiguration();
  }

  /**
   * @inheritdoc
   */
  public function setConfiguration(array $configuration): self {
    $this->typedInputs->setConfiguration($configuration);
    return $this;
  }

  /**
   * @inheritdoc
   */
  public function defaultConfiguration(): array {
    return $this->typedInputs->defaultConfiguration();
  }

}
