<?php

declare(strict_types=1);

namespace Drupal\tool\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\tool\Tool\ToolDefinition;

/**
 * The tool attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class Tool extends Plugin {

  /**
   * Constructs a new Tool instance.
   *
   * @param string $id
   *   The plugin ID. There are some implementation bugs that make the plugin
   *   available only if the ID follows a specific pattern. It must be either
   *   identical to group or prefixed with the group. E.g. if the group is "foo"
   *   the ID must be either "foo" or "foo:bar".
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable name of the plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $description
   *   A brief description of the plugin.
   * @param \Drupal\tool\TypedData\InputDefinitionInterface[] $input_definitions
   *    (optional) An array of context definitions describing the context used by
   * @param \Drupal\Core\Plugin\Context\ContextDefinitionInterface[] $output_definitions
   *    (optional) Leave empty, will be auto filled by $input_definitions.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   * @param array<string, string|false> $forms
   *    (optional) An array of form class names or FALSE, keyed by a string.
   * @param bool $destructive
   *    (optional) Whether the tool is destructive. Encourage confirmation.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly TranslatableMarkup $description,
    public readonly ?array $input_definitions = [],
    public readonly ?array $output_definitions = [],
    public readonly ?string $deriver = NULL,
    public readonly ?array $forms = [],
    public readonly bool $destructive = false,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function get(): ToolDefinition {
    return new ToolDefinition(parent::get());
  }

}
