<?php

namespace Drupal\tool\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\SubformState;

class ConfigureToolPluginForm extends ToolPluginFormBase {
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    foreach ($this->plugin->getContextDefinitions() as $name => $definition) {
      $form[$name] = [];
      $subform_state = SubformState::createForSubform($form[$name], $form, $form_state);
      $form[$name] = $this->plugin->getFormElement($name, $form[$name], $subform_state);
    }
    return $form;
  }

  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    // TODO: Implement submitConfigurationForm() method.
  }
}
