<?php

namespace Drupal\ai\OperationType\TextToSpeech;

use Drupal\ai\OperationType\OutputInterface;
use Drupal\ai\Traits\File\GenerateFileTrait;
use Drupal\ai\Traits\File\GenerateMediaTrait;

/**
 * Data transfer output object for text to speech output.
 */
class TextToSpeechOutput implements OutputInterface {

  // We want to be able to store as media and file.
  use GenerateMediaTrait;
  use GenerateFileTrait;

  /**
   * The normalized audio binary.
   *
   * @var array
   */
  private array $normalized;

  /**
   * The raw output from the AI provider.
   *
   * @var mixed
   */
  private mixed $rawOutput;

  /**
   * The metadata from the AI provider.
   *
   * @var mixed
   */
  private mixed $metadata;

  public function __construct(mixed $normalized, mixed $rawOutput, mixed $metadata) {
    $this->normalized = $normalized;
    $this->rawOutput = $rawOutput;
    $this->metadata = $metadata;
  }

  /**
   * Returns an array of binary strings of audios.
   *
   * @return array
   *   The audio binary strings.
   */
  public function getNormalized(): array {
    return $this->normalized;
  }

  /**
   * Gets the raw output from the AI provider.
   *
   * @return mixed
   *   The raw output.
   */
  public function getRawOutput(): mixed {
    return $this->rawOutput;
  }

  /**
   * Gets the metadata from the AI provider.
   *
   * @return mixed
   *   The metadata.
   */
  public function getMetadata(): mixed {
    return $this->metadata;
  }

  /**
   * {@inheritdoc}
   */
  public function toArray(): array {
    return [
      'normalized' => $this->normalized,
      'rawOutput' => $this->rawOutput,
      'metadata' => $this->metadata,
    ];
  }

}
