<?php

namespace Drupal\tool\TypedData;

use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\Plugin\Context\ContextDefinitionInterface;

class ListContextDefinition extends ContextDefinition {
  protected ?ContextDefinitionInterface $item_definition;

  /**
   * Constructs a new context definition object.
   *
   * @param string $data_type
   *   The required data type.
   * @param string|null|\Stringable $label
   *   The label of this context definition for the UI.
   * @param bool $required
   *   Whether the context definition is required.
   * @param bool $multiple
   *   Whether the context definition is multivalue.
   * @param string|null $description
   *   The description of this context definition for the UI.
   * @param mixed $default_value
   *   The default value of this definition.
   * @param array $constraints
   *   An array of constraints keyed by the constraint name and a value of an
   *   array constraint options or a NULL.
   */
  public function __construct($data_type = 'list', $label = NULL, $required = TRUE, $multiple = FALSE, $description = NULL, $default_value = NULL, array $constraints = [], ContextDefinitionInterface $item_definition = null) {
    parent::__construct('list', $label, $required, $multiple, $description, $default_value, $constraints);
    $this->item_definition = $item_definition;
  }

  public function setItemDefinition(ContextDefinitionInterface $item_definition): self {
    $this->item_definition = $item_definition;
    return $this;
  }

  public function getItemDefinition(): ContextDefinitionInterface {
    if (!$this->item_definition) {
      return new ContextDefinition('any', 'Any');
    }
    return $this->item_definition;
  }

}
