<?php

namespace Drupal\tool\TypedData\SchemaWidget;

use Drupal\Core\TypedData\DataDefinitionInterface;
use Drupal\Core\TypedData\TypedDataTrait;

trait TypedDataSchemaWidgetTrait {

  use TypedDataTrait;

  protected TypedDataSchemaWidgetPluginManager $schemaWidgetManager;
  protected array $schemaWidgetInstances = [];

  protected function getSchemaWidgetManager() {
    if (empty($this->schemaWidgetManager)) {
      $this->schemaWidgetManager = \Drupal::service('plugin.manager.typed_data_schema_widget');
    }
    return $this->schemaWidgetManager;
  }

  public function getSchemaWidgetInstance(DataDefinitionInterface $data_definition, string $name) {
    if (!isset($this->schemaWidgetInstances[$name])) {
      $schema_widget_definition = $this->getSchemaWidgetManager()->getDefinitionFromDataType($data_definition);
      $this->schemaWidgetInstances[$name] = $this->getSchemaWidgetManager()->createInstance($schema_widget_definition['id']);
    }
    return $this->schemaWidgetInstances[$name];
  }

}
