<?php

namespace Drupal\tool_ai_connector\Plugin\AiFunctionCall\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\tool\Tool\ToolManager;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a base function call for each entity type with specific interfaces.
 */
class ToolPluginDeriver extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  /**
   * Constructs a new ToolPluginDeriver object.
   *
   * @param \Drupal\tool\Tool\ToolManager $toolManager
   */
  public function __construct(
    protected ToolManager $toolManager,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('plugin.manager.tool'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    if (empty($this->derivatives)) {
      $definitions = [];
      foreach ($this->toolManager->getDefinitions() as $id => $tool_definition) {
          /** @var \Drupal\tool\Tool\ToolDefinition $tool_definition */
          $definition = $base_plugin_definition;
          $definition['id'] = 'tool:' . $id;
          $definition['name'] = $tool_definition->getLabel();
          $definition['group'] = 'tool';
          $definition['function_name'] = str_replace(':', '__', $definition['id']);
          $definition['description'] = $tool_definition->getDescription();
          $definition['context_definitions'] = $tool_definition->getInputDefinitions();
          $definitions[$id] = $definition;
      }
      $this->derivatives = $definitions;
    }
    return parent::getDerivativeDefinitions($base_plugin_definition);
  }

}
