<?php

namespace Drupal\tool\Normalizer;

use Drupal\Core\TypedData\Plugin\DataType\Map;
use Drupal\serialization\Normalizer\ComplexDataNormalizer;
use Drupal\serialization\Normalizer\SchematicNormalizerTrait;

class MapDefinitionNormalizer extends ComplexDataNormalizer {

  use SchematicNormalizerTrait;

  protected function doNormalize($object, $format = NULL, array $context = []): array|string|int|float|bool|\ArrayObject|null {
    return null;
  }


  protected function getNormalizationSchema(mixed $object, array $context = []): array {
    $schema = [
      'type' => 'object',
    ];

    foreach($object->getDataDefinition()->getPropertyDefinitions() as $name => $property_definition) {
      $data = $property_definition->getTypedDataManager()->create($property_definition);
      $property_schema = $this->serializer->getJsonSchema($data, $context);
      if ($property_schema) {
        $schema['properties'][$name] = $property_schema;
        if ($property_definition->isRequired()) {
          $schema['required'] ??= [];
          $schema['required'][] = $name;
        }
      }
    }
    return $schema;

  }

  /**
   * {@inheritdoc}
   */
  public function getSupportedTypes(?string $format): array {
    return [
      Map::class => ($format === 'json_schema'),
    ];
  }

}
