<?php

declare(strict_types=1);

namespace Drupal\tool\Plugin\tool\TypedData\SchemaWidget;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\SubformStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\TypedDataInterface;
use Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetBase;
use Drupal\tool\Attribute\TypedDataSchemaWidget;
use Symfony\Component\Validator\ConstraintViolationListInterface;

/**
 * Plugin implementation of the data_type_form_widget.
 */
#[TypedDataSchemaWidget(
  id: 'email',
  label: new TranslatableMarkup('Email'),
  description: new TranslatableMarkup('Email input for email data types.'),
  data_types: ['email'],
)]
final class EmailWidget extends TypedDataSchemaWidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(TypedDataInterface $data, array $element, SubformStateInterface $form_state): array {
    $form['value'] = [
      '#type' => 'email',
      '#title' => $data->getDataDefinition()->getLabel(),
      '#default_value' => $data->getValue(),
      '#description' => $data->getDataDefinition()->getDescription(),
      '#required' => $data->getDataDefinition()->isRequired(),
      '#description_display' => 'after',
      '#disabled' => $data->getDataDefinition()->isReadOnly(),
    ];
    return $form;
  }

}
