<?php

namespace Drupal\tool\TypedData;

use Drupal\Core\Plugin\Context\ContextDefinitionInterface;

interface InputDefinitionInterface extends ContextDefinitionInterface {

  /**
   * Returns if the input is locked.
   *
   * @return bool
   *   Returns TRUE if the input is locked, FALSE otherwise.
   */
  public function isLocked(): bool;

  /**
   * Sets whether the value is locked.
   *
   * @param bool $locked
   *   Whether a data value is locked.
   *
   * @return $this
   */
  public function setLocked($locked = TRUE): self;

  /**
   * Returns the form alter values or callback.
   *
   * @return array
   *   An array of form properties or a callback to alter the form element.
   */
  public function getFormAlter(): array;

  /**
   * Sets the form alter values or callback.
   *
   * @param array $form_alter
   *   An array of form properties or a callback to alter the form element.
   *
   * @return $this
   */
  public function setFormAlter(array $form_alter): self;

  /**
   * Returns the config schema override definitions.
   *
   * @return array
   *   An array of config schema definitions to override the default schema for this input.
   */
  public function getConfigSchemaOverride(): array;

  /**
   * Sets the config schema override definitions.
   *
   * @param array $config_schema_override
   *   An array of config schema definitions to override the default schema for this input.
   *
   * @return $this
   */
  public function setConfigSchemaOverride(array $config_schema_override): self;

}
