<?php

declare(strict_types=1);

namespace Drupal\tool\TypedData\SchemaWidget;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\SubformStateInterface;
use Drupal\Core\TypedData\DataDefinitionInterface;
use Drupal\Core\TypedData\TypedDataInterface;
use Symfony\Component\Validator\ConstraintViolationListInterface;

/**
 * Interface for data_type_form_widget plugins.
 */
interface TypedDataSchemaWidgetInterface {

  /**
   * Returns the translated plugin label.
   */
  public function label(): string;

  public static function isApplicable(DataDefinitionInterface $data_definition): bool;

  public function formElement(TypedDataInterface $data, array $element, SubformStateInterface $form_state): array;

//  public function flagViolations(TypedDataInterface $data, ConstraintViolationListInterface $violations, SubformStateInterface $formState): void;

  public function extractFormValues(TypedDataInterface $data, SubformStateInterface $form_state): void;

}
