<?php

namespace Drupal\tool;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Core\Form\SubformStateInterface;
use Drupal\tool\Exception\InputException;
use Drupal\tool\TypedData\InputDefinitionInterface;
use Drupal\tool\TypedData\SchemaWidget\TypedDataSchemaWidgetInterface;
use Symfony\Component\Validator\ConstraintViolationList;
use Symfony\Component\Validator\ConstraintViolationListInterface;

interface TypedInputsInterface extends ConfigurableInterface {

  /**
   * Gets the input definitions.
   *
   * @return \Drupal\tool\TypedData\InputDefinitionInterface[]
   *   An array of input definitions keyed by their names.
   */
  public function getInputDefinitions($include_locked = FALSE): array;

  /**
   * Gets a specific input definition by name.
   *
   * @param string $name
   *   The name of the input definition.
   *
   * @return \Drupal\tool\TypedData\InputDefinitionInterface|InputException
   *  The input definition object or an InputException if not found.
   */
  public function getInputDefinition(string $name): InputDefinitionInterface|InputException;

  /**
   * Gets the executable values for the inputs.
   *
   * @return array
   *   An array of executable values.
   */
  public function getExecutableValues($skip_validation = FALSE): array;

//  /**
//   * Sets a context value by name.
//   *
//   * @param string $name
//   *   The name of the context.
//   * @param mixed $value
//   *   The value to set for the context.
//   *
//   * @return $this
//   *   The current instance for method chaining.
//   */
//  public function setContextValue(string $name, mixed $value): self;

//  /**
//   * todo TBD.
//   * @deprecated
//   */
//  public function getFormWidgetInstance(string $name): TypedDataSchemaWidgetInterface;
//
//  /**
//   * todo TBD.
//   * @deprecated
//   */
//  public function getFormElement(string $name, array &$element, SubformStateInterface $subform_state): array;

  /**
   * Gets the configuration for the typed inputs.
   *
   * @return array
   *   An array of configuration settings.
   */
  public function getConfiguration(): array;

  /**
   * Sets the configuration for the typed inputs.
   *
   * @param array $configuration
   *   An array of configuration settings.
   *
   * @return $this
   *   The current instance for method chaining.
   */
  public function setConfiguration(array $configuration): self;

  /**
   * Provides the default configuration for the typed inputs.
   *
   * @return array
   *   An array of default configuration settings.
   */
  public function defaultConfiguration(): array;

  /**
   * Sets the input definitions for the typed inputs.
   *
   * @param array $definitions
   *   An array of input definitions.
   *
   * @return $this
   *   The current instance for method chaining.
   */
  public function setInputValue(string $name, $value): self;

  /**
   * Gets the value of a specific input by name.
   *
   * @param string $name
   *   The name of the input.
   *
   * @return mixed
   *   The value of the input.
   */
  public function getInputValue(string $name): mixed;

  /**
   * Checks if a specific input value is valid.
   *
   * @param string $name
   *   The name of the input.
   *
   * @return bool
   *   TRUE if the input value is valid, FALSE otherwise.
   */
  public function validateInputValues($values): ConstraintViolationListInterface;

  /**
   * Validates a specific input value by name.
   *
   * @param string $name
   *   The name of the input.
   * @param mixed $value
   *   The value to validate.
   *
   * @return \Symfony\Component\Validator\ConstraintViolationListInterface
   *   A list of constraint violations, if any.
   */
  public function validateInputValue($name, $value): ConstraintViolationListInterface;

}
