<?php

declare(strict_types=1);

namespace Drupal\tool\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The data_type_form_widget attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class TypedDataSchemaWidget extends AttributeBase {

  /**
   * Constructs a new TypedDataSchemaWidget instance.
   *
   * @param string $id
   *   The plugin ID. There are some implementation bugs that make the plugin
   *   available only if the ID follows a specific pattern. It must be either
   *   identical to group or prefixed with the group. E.g. if the group is "foo"
   *   the ID must be either "foo" or "foo:bar".
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   (optional) The human-readable name of the plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   (optional) A brief description of the plugin.
   * @param array $data_types
   *   (optional) The data types this widget applies to.
   * @param int|null $weight
   *   (optional) The weight of the plugin. Used to order plugins in lists.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $label,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly array $data_types = [],
    public readonly ?int $weight = 0,
    public readonly ?string $deriver = NULL,
  ) {}

}
